#ifndef _AFE_COMM_H_
#define _AFE_COMM_H_

/////////////////////meter communication packet///////////////////////////////
#define AFE_READ_PACKET_SIZE  5
#define AFE_WRITE_PACKET_SIZE  4

enum host_commands_e
{
//CALIBRATION REGISTER READ
    AFE_CMD_GET_METER_I1RMS_OFFSET             = 0x40,
    AFE_CMD_GET_METER_I2RMS_OFFSET             = 0x41,
    AFE_CMD_GET_METER_I1RMS_GAIN               = 0x42,
    AFE_CMD_GET_METER_I2RMS_GAIN               = 0x43,
    AFE_CMD_GET_METER_P1_GAIN                  = 0x44,
    AFE_CMD_GET_METER_P2_GAIN                  = 0x45,
    AFE_CMD_GET_METER_P1_PHASE                 = 0x46,
    AFE_CMD_GET_METER_P2_PHASE                 = 0x47,
    AFE_CMD_GET_METER_P1_OFFSET                = 0x48,
    AFE_CMD_GET_METER_P2_OFFSET                = 0x49,
    AFE_CMD_GET_METER_Q1_OFFSET                = 0x4A,
    AFE_CMD_GET_METER_Q2_OFFSET                = 0x4B,
    AFE_CMD_GET_METER_VRMS_GAIN                = 0x4C,
    //V5
    AFE_CMD_GET_READINGS_VDC                   = 0x4D,  
    AFE_CMD_GET_READINGS_I1DC                  = 0x4E,   
    AFE_CMD_GET_READINGS_I2DC                  = 0x4F,  
//METERING REGISTER READ
    AFE_CMD_GET_READINGS_P1                    = 0x60,
    AFE_CMD_GET_READINGS_P2                    = 0x61,
    AFE_CMD_GET_READINGS_Q1                    = 0x62,
    AFE_CMD_GET_READINGS_Q2                    = 0x63,
    AFE_CMD_GET_READINGS_S1                    = 0x64,
    AFE_CMD_GET_READINGS_S2                    = 0x65,
    AFE_CMD_GET_READINGS_VRMS                  = 0x66,
    AFE_CMD_GET_READINGS_FREG                  = 0x67,
    AFE_CMD_GET_READINGS_I1RMS                 = 0x68,
    AFE_CMD_GET_READINGS_I2RMS                 = 0x69,
    AFE_CMD_GET_READINGS_PF1                   = 0x6A,
    AFE_CMD_GET_READINGS_PF2                   = 0x6B,
    AFE_CMD_GET_READINGS_ACTENERGY1            = 0x6C,
    AFE_CMD_GET_READINGS_REACTENERGY1          = 0x6D,   
    //V5
    AFE_CMD_GET_READINGS_NEGTIVE_ACTENERGY1    = 0x6E,
    AFE_CMD_GET_READINGS_NEGTIVE_REACTENERGY1  = 0x6F,  
    AFE_CMD_GET_READINGS_VWFS                  = 0x70,  
    AFE_CMD_GET_READINGS_I1WFS                 = 0x71,  
    AFE_CMD_GET_READINGS_I2WFS                 = 0x72,     
//CONFIGURATION REGISTER READ 
    AFE_CMD_GET_METER_EMPTY                    = 0x00,
    AFE_CMD_GET_METER_SYSCONF                  = 0x74,
    AFE_CMD_GET_METER_CSGCONF                  = 0x75,
    AFE_CMD_GET_METER_POWER_CONST              = 0x76,
    AFE_CMD_GET_METER_START_CURRENT            = 0x77,    
    AFE_CMD_GET_READINGS_IE                    = 0x78,   
    AFE_CMD_GET_READINGS_IFG                   = 0x79,   
    AFE_CMD_GET_READINGS_STATUS                = 0x7A,         
    AFE_CMD_GET_READINGS_CHECKSUM1             = 0x7B,
    AFE_CMD_GET_READINGS_WREN                  = 0x7C,
    AFE_CMD_GET_READINGS_METER_STATUS          = 0x7D,
    AFE_CMD_GET_READINGS_RXBUF                 = 0x7E,   
    AFE_CMD_GET_READINGS_TXBUF                 = 0x7F,         

   
//CALIBRATION REGISTER WRITE
    AFE_CMD_SET_METER_I1RMS_OFFSET             = 0x80,
    AFE_CMD_SET_METER_I2RMS_OFFSET             = 0x81,
    AFE_CMD_SET_METER_I1RMS_GAIN               = 0x82,
    AFE_CMD_SET_METER_I2RMS_GAIN               = 0x83,
    AFE_CMD_SET_METER_P1_GAIN                  = 0x84,
    AFE_CMD_SET_METER_P2_GAIN                  = 0x85,
    AFE_CMD_SET_METER_P1_PHASE                 = 0x86,
    AFE_CMD_SET_METER_P2_PHASE                 = 0x87,
    AFE_CMD_SET_METER_P1_OFFSET                = 0x88,
    AFE_CMD_SET_METER_P2_OFFSET                = 0x89,
    AFE_CMD_SET_METER_Q1_OFFSET                = 0x8A,
    AFE_CMD_SET_METER_Q2_OFFSET                = 0x8B,
    AFE_CMD_SET_METER_VRMS_GAIN                = 0x8C,   
    //V5
    AFE_CMD_SET_READINGS_VDC                   = 0x8D,  
    AFE_CMD_SET_READINGS_I1DC                  = 0x8E,   
    AFE_CMD_SET_READINGS_I2DC                  = 0x8F,  
//CONFIGURATION REGISTER WRITE    
    AFE_CMD_SET_METER_SYSCONF                  = 0xB4,
    AFE_CMD_SET_METER_CSGCONF                  = 0xB5,
    AFE_CMD_SET_METER_POWER_CONST              = 0xB6,
    AFE_CMD_SET_METER_START_CURRENT            = 0xB7,    
    AFE_CMD_SET_IE                             = 0xB8,       
    AFE_CMD_SET_WREN                           = 0xBC,   
    AFE_CMD_SET_SRST                           = 0xBD, 
};

#define AFE_WREN_REG  0xC500
#define AFE_WREN      0x00CA
/////////////////////meter communication packet///////////////////////////////
typedef union
{
    unsigned char uint8[6];
    unsigned int uint16[3];
} afe_msg_t;
extern unsigned char host_command;
extern afe_msg_t afe_read_message;
extern unsigned char afe_write_message[5];
extern unsigned char afe_write_msg_len;
extern unsigned char afe_write_msg_ptr;
extern unsigned char afe_read_msg_len;
extern unsigned char afe_read_msg_ptr;
///////////////////////////////////////////////////////////////////////
/////////////////////meter communication, use USART////////////////////
///////////////////////////////////////////////////////////////////////
char afe_write(int len);
char prepare_afe_write(unsigned char command, int value, int len);
char afe_read(unsigned char command);
void afe_read_ifg();
void afe_read_params();
void afe_read_calibrations();
void afe_set_calibrations();
void afe_set_registers();
void afe_softreset();
void afe_read_configurations();
void decode_afe_param();

#endif